/*
 * Decompiled with CFR 0.152.
 */
package panther.util.crypto;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import panther.util.general.Constants;

public class ObfuscateEncode {
    private static final String map = new String("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");

    public static String encode(Collection collection) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            ObfuscateEncode.encodeLength(stringBuffer, string.length());
            stringBuffer.append(string);
            ++n;
        }
        return ObfuscateEncode.encode(stringBuffer.toString());
    }

    private static void encodeLength(StringBuffer stringBuffer, int n) {
        if (n > 65535) {
            throw new IllegalArgumentException(Constants.fillIn("Unable to encode string length > FOO1", 65535));
        }
        if (n < 4096) {
            stringBuffer.append('0');
        }
        if (n < 256) {
            stringBuffer.append('0');
        }
        if (n < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toHexString(n));
    }

    public static String encode(String string) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes("utf-8");
        ObfuscateEncode.encode(byArray, 0, byArray.length);
        return ObfuscateEncode.roughEncode(byArray, 0, byArray.length);
    }

    public static void encode(byte[] byArray, int n, int n2) {
        n2 &= 0xFFFFFFFE;
        while (n < n2) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 1];
            byArray[n + 1] = by;
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] + 18);
            int n4 = n + 1;
            byArray[n4] = (byte)(byArray[n4] + 73);
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] ^ 0xA4);
            int n6 = n + 1;
            byArray[n6] = (byte)(byArray[n6] ^ 0x7E);
            n += 2;
        }
    }

    public static String roughEncode(byte[] byArray, int n, int n2) {
        return ObfuscateEncode.roughEncode(map, byArray, n, n2);
    }

    public static String roughEncode(String string, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > 0) {
            int n3 = n2 > 3 ? 3 : n2;
            int n4 = 16;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                n5 |= (byArray[n] & 0xFF) << n4;
                ++n6;
                n4 -= 8;
                ++n;
            }
            n4 = 18;
            for (n6 = 0; n6 <= n3; ++n6) {
                stringBuffer.append(string.charAt(n5 >> n4 & 0x3F));
                n4 -= 6;
            }
            while (n6 < 4) {
                stringBuffer.append('=');
                ++n6;
            }
            n2 -= n3;
        }
        return stringBuffer.toString();
    }
}

